/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.CorrSet;
import filenet.vw.api.IVWCanCreateParameters;
import filenet.vw.api.IVWHasWSParameterDefs;
import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWAssociationTargetType;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWWFEInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowRuntimeId;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLSchemaSubType;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.api.VWXPDL_20_parser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class VWXML_CUR_parser {
    VWXML_CUR_parser() {
    }

    protected static VWWorkflowDefinition parseXMLWorkflow(Element wfele) throws VWException, SAXException {
        if (!wfele.getTagName().equals("WorkFlowDefinition")) {
            return null;
        }
        VWWorkflowDefinition wfdef = new VWWorkflowDefinition(true);
        if (wfele.getAttributeNode("Name") != null) {
            wfdef.setName(wfele.getAttribute("Name"));
        }
        if (wfele.getAttributeNode("Subject") != null) {
            wfdef.setSubject(wfele.getAttribute("Subject"));
        }
        if (wfele.getAttributeNode("Description") != null) {
            wfdef.setDescription(wfele.getAttribute("Description"));
        }
        if (wfele.getAttributeNode("MainAttachment") != null) {
            wfdef.setMainAttachmentNameNoValidate(wfele.getAttribute("MainAttachment"));
        }
        if (wfele.getAttributeNode("Deadline") != null) {
            wfdef.setDeadline(Long.parseLong(wfele.getAttribute("Deadline")));
        }
        if (wfele.getAttributeNode("Reminder") != null) {
            wfdef.setReminder(Long.parseLong(wfele.getAttribute("Reminder")));
        }
        if (wfele.getAttributeNode("DisableEmailNotification") != null) {
            wfdef.setDisableEmailNotification(VWXMLHandler.stringToBoolean(wfele.getAttribute("DisableEmailNotification")));
        }
        if (wfele.getAttributeNode("BaseWorkClass") != null) {
            wfdef.setBaseWorkClassName(wfele.getAttribute("BaseWorkClass"));
        }
        if (wfele.getAttributeNode("Roster") != null) {
            wfdef.setRosterName(wfele.getAttribute("Roster"));
        }
        if (wfele.getAttributeNode("EventLog") != null) {
            wfdef.setEventLogName(wfele.getAttribute("EventLog"));
        }
        if (wfele.getAttributeNode("Tag") != null) {
            wfdef.setTag(wfele.getAttribute("Tag"));
        }
        if (wfele.getAttributeNode("IncomingWSAttachmentFolder") != null) {
            wfdef.setIncomingWSAttachmentFolder(wfele.getAttribute("IncomingWSAttachmentFolder"));
        }
        if (wfele.getAttributeNode("AuthorTool") != null) {
            wfdef.setAuthorTool(wfele.getAttribute("AuthorTool"));
        }
        if (wfele.getAttributeNode("OtherAuthorTools") != null) {
            wfdef.setOtherAuthorTools(wfele.getAttribute("OtherAuthorTools"));
        }
        if (wfele.getAttributeNode("versionAgnostic") != null) {
            wfdef.setVersionAgnostic(VWXMLHandler.stringToBoolean(wfele.getAttribute("versionAgnostic")));
        } else {
            wfdef.setVersionAgnostic(false);
        }
        if (wfele.getAttributeNode("validateUsingSchema") != null) {
            wfdef.setValidateUsingSchema(VWXMLHandler.stringToBoolean(wfele.getAttribute("validateUsingSchema")));
        } else {
            wfdef.setValidateUsingSchema(false);
        }
        if (wfele.getAttributeNode("validateFlag") != null) {
            wfdef.setValidateFlag(VWXMLHandler.stringToBoolean(wfele.getAttribute("validateFlag")));
        }
        if (wfele.getAttributeNode("transferFlag") != null) {
            wfdef.setValidateFlag(VWXMLHandler.stringToBoolean(wfele.getAttribute("transferFlag")));
        }
        NodeList childNodes = wfele.getChildNodes();
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node aNode = childNodes.item(i);
            if (aNode.getNodeName().equals("Field")) {
                VWXML_CUR_parser.parseXMLFieldDefinition(aNode, wfdef);
                continue;
            }
            if (aNode.getNodeName().equals("Map")) {
                VWXML_CUR_parser.parseXMLMapDefinition(aNode, wfdef);
                continue;
            }
            if (aNode.getNodeName().equals("Milestone")) {
                VWXML_CUR_parser.parseXMLMilestoneDefinition(aNode, wfdef);
                continue;
            }
            if (aNode.getNodeName().equals("partnerLinks")) {
                VWXML_CUR_parser.parseXMLPartnerLinks(aNode, wfdef);
                continue;
            }
            if (aNode.getNodeName().equals("types")) {
                VWXML_CUR_parser.parseXMLSchemas(aNode, wfdef);
                continue;
            }
            if (aNode.getNodeName().equals("RuleSet")) {
                VWXML_CUR_parser.parseXMLRuleSetDefinition(aNode, wfdef);
                continue;
            }
            if (aNode.getNodeName().equals("ModelAttributes")) {
                Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(aNode);
                wfdef.setAttributes(attributes);
                continue;
            }
            if (!aNode.getNodeName().equals("WFRuntimeId")) continue;
            VWXML_CUR_parser.parseXMLRuntimeId(aNode, wfdef);
        }
        return wfdef;
    }

    protected static void parseXMLFieldDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        String valueStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        int typeInt = VWFieldType.stringToType(ele.getAttribute("Type"));
        boolean isArrayBool = VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray"));
        int mergeInt = VWMergeType.stringToType(ele.getAttribute("MergeType"));
        VWFieldDefinition fldDef = nameStr != null && nameStr.equals("F_Trackers") ? wfdef.createFieldNoValidateName(nameStr, valueStr, typeInt, isArrayBool) : wfdef.createFieldUsingString(nameStr, valueStr, typeInt, isArrayBool);
        fldDef.setMergeType(mergeInt);
        if (ele.getAttributeNode("Description") != null) {
            fldDef.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("ElementName") != null) {
            fldDef.setXMLSchemaElement(ele.getAttribute("ElementName"));
        }
        if (ele.getAttributeNode("SchemaName") != null) {
            fldDef.setXMLSchemaName(ele.getAttribute("SchemaName"));
        }
        if (ele.getAttributeNode("RequiredClass") != null) {
            fldDef.setRequiredClass(new VWGuid(ele.getAttribute("RequiredClass")));
        }
    }

    protected static void parseXMLMilestoneDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        VWMilestoneDefinition mileStone = wfdef.createMilestone(nameStr);
        if (ele.getAttributeNode("Message") != null) {
            mileStone.setMessage(ele.getAttribute("Message"));
        }
        if (ele.getAttributeNode("Level") != null) {
            mileStone.setLevel(Integer.parseInt(ele.getAttribute("Level")));
        }
    }

    protected static void parseXMLPartnerLinks(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.hasChildNodes()) {
            NodeList attribNodes = aNode.getChildNodes();
            int childNodeCount = attribNodes.getLength();
            for (int j = 0; j < childNodeCount; ++j) {
                Node asNode = attribNodes.item(j);
                if (attribNodes.item(j).getNodeType() != 1 || !attribNodes.item(j).getNodeName().equals("partnerLink")) continue;
                VWXML_CUR_parser.parseXMLPartnerLinkDefinition(asNode, wfdef);
            }
        }
    }

    protected static void parseXMLSchemas(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.hasChildNodes()) {
            NodeList attribNodes = aNode.getChildNodes();
            for (int i = 0; i < attribNodes.getLength(); ++i) {
                String nodeName;
                Node asNode = attribNodes.item(i);
                if (attribNodes.item(i).getNodeType() != 1 || (nodeName = attribNodes.item(i).getLocalName()) == null || !nodeName.equals("schema")) continue;
                VWXML_CUR_parser.parseXMLSchema(asNode, wfdef);
            }
        }
    }

    protected static void parseXMLPartnerLinkDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        if (ele.getAttributeNode("name") != null) {
            nameStr = ele.getAttribute("name");
        }
        VWPartnerLinkDefinition partnerLink = wfdef.createPartnerLink(nameStr);
        if (ele.getAttributeNode("myPortType") != null) {
            partnerLink.setMyPortType(ele.getAttribute("myPortType"));
        }
        if (ele.getAttributeNode("myRole") != null) {
            partnerLink.setMyRole(ele.getAttribute("myRole"));
        }
        if (ele.getAttributeNode("partnerEndPoint") != null) {
            partnerLink.setPartnerEndPoint(ele.getAttribute("partnerEndPoint"));
        }
        if (ele.getAttributeNode("partnerPortType") != null) {
            partnerLink.setPartnerPortType(ele.getAttribute("partnerPortType"));
        }
        if (ele.getAttributeNode("partnerRole") != null) {
            partnerLink.setPartnerRole(ele.getAttribute("partnerRole"));
        }
        if (ele.getAttributeNode("partnerWSDLRef") != null) {
            partnerLink.setWSDLRef(ele.getAttribute("partnerWSDLRef"));
        }
        if (ele.getAttributeNode("partnerLinkRef") != null) {
            partnerLink.setPartnerLinkRef(ele.getAttribute("partnerLinkRef"));
        }
    }

    protected static void parseXMLSchema(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = null;
        if (ele.getAttributeNode("name") != null) {
            nameStr = ele.getAttribute("name");
        }
        VWSchema newSchema = wfdef.createSchema(nameStr);
        if (ele.getAttributeNode("schema") != null) {
            newSchema.setSchema(ele.getAttribute("schema"));
        }
        if (ele.getAttributeNode("file") != null) {
            newSchema.setFileName(ele.getAttribute("file"));
        }
    }

    protected static void parseXMLRuleSetDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String valueStr = null;
        if (ele.getAttributeNode("Val") != null) {
            valueStr = ele.getAttribute("Val");
        }
        VWRuleSetDefinition ruleSet = wfdef.createRuleSet(valueStr);
        if (ele.getAttribute("Expensive") != null) {
            ruleSet.setExpensive(VWXMLHandler.stringToBoolean(ele.getAttribute("Expensive")));
        }
    }

    protected static void parseXMLMapDefinition(Node aNode, VWWorkflowDefinition wfdef) throws VWException, SAXException, NumberFormatException {
        Element ele = (Element)aNode;
        NodeList childNodes = aNode.getChildNodes();
        String nameStr = ele.getAttribute("Name");
        VWMapDefinition map = wfdef.createEmptyMap(nameStr);
        if (ele.getAttributeNode("Description") != null) {
            map.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("MapId") != null) {
            map.setMapId(Integer.parseInt(ele.getAttribute("MapId")));
        }
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Step")) {
                VWXML_CUR_parser.parseXMLStepDefinition(childNode, map, null);
            }
            if (childNode.getNodeName().equals("CompoundStep")) {
                VWXML_CUR_parser.parseXMLCompoundStepDefinition(childNode, map, null);
            }
            if (!childNode.getNodeName().equals("TextAnnotation")) continue;
            VWXML_CUR_parser.parseXMLTextAnnotationDefinition(childNode, map);
        }
        if (ele.getAttributeNode("MaxStepId") != null) {
            int maxStepId = Integer.parseInt(ele.getAttribute("MaxStepId"));
            if (maxStepId >= map.findHighestStepId()) {
                map.getStepIdGenerator().setNextId(maxStepId + 1);
            } else {
                map.updateNextStepId();
            }
        } else {
            map.updateNextStepId();
        }
        map.updateNextAnnotationId();
        VWMapNode[] steps = map.getSteps();
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                VWXPDL_20_parser.checkForDuplicateIds(steps[i], steps, map);
            }
        }
    }

    protected static void parseXMLTextAnnotationDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException, NumberFormatException {
        Element ele = (Element)aNode;
        NodeList childNodes = aNode.getChildNodes();
        int annotationId = -1;
        String msg = null;
        String xcoordStr = null;
        String ycoordStr = null;
        String hStr = null;
        String wStr = null;
        String redStr = null;
        String greenStr = null;
        String blueStr = null;
        if (ele.getAttributeNode("Message") != null) {
            msg = ele.getAttribute("Message");
        }
        VWTextAnnotationDefinition theAnnotation = map.createTextAnnotation(msg);
        if (ele.getAttributeNode("Name") != null) {
            theAnnotation.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("XCoordinate") != null) {
            xcoordStr = ele.getAttribute("XCoordinate");
        }
        if (ele.getAttributeNode("YCoordinate") != null) {
            ycoordStr = ele.getAttribute("YCoordinate");
        }
        if (xcoordStr != null && ycoordStr != null) {
            theAnnotation.setLocation(new Point(Integer.parseInt(xcoordStr), Integer.parseInt(ycoordStr)));
        }
        if (ele.getAttributeNode("Height") != null) {
            hStr = ele.getAttribute("Height");
        }
        if (ele.getAttributeNode("Width") != null) {
            wStr = ele.getAttribute("Width");
        }
        if (hStr != null && wStr != null) {
            theAnnotation.setDimension(new Dimension(Integer.parseInt(wStr), Integer.parseInt(hStr)));
        }
        if (ele.getAttributeNode("colorRed") != null) {
            redStr = ele.getAttribute("colorRed");
        }
        if (ele.getAttributeNode("colorGreen") != null) {
            greenStr = ele.getAttribute("colorGreen");
        }
        if (ele.getAttributeNode("colorBlue") != null) {
            blueStr = ele.getAttribute("colorBlue");
        }
        if (redStr != null && greenStr != null && blueStr != null) {
            theAnnotation.setBgColor(new Color(Integer.parseInt(redStr), Integer.parseInt(greenStr), Integer.parseInt(blueStr)));
        }
        if (ele.getAttributeNode("Minimized") != null) {
            theAnnotation.setMinimized(VWXMLHandler.stringToBoolean(ele.getAttribute("Minimized")));
        }
        if (ele.getAttributeNode("Id") != null) {
            annotationId = Integer.parseInt(ele.getAttribute("Id"));
            theAnnotation.setId(annotationId);
        }
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Association")) continue;
            VWXML_CUR_parser.parseXMLAssociationDefinition(childNode, theAnnotation);
        }
    }

    protected static void parseXMLAssociationDefinition(Node aNode, VWTextAnnotationDefinition annotation) throws VWException, SAXException, NumberFormatException {
        Element ele = (Element)aNode;
        int targId = -1;
        int targType = -1;
        if (ele.getAttributeNode("TargetId") != null) {
            targId = Integer.parseInt(ele.getAttribute("TargetId"));
        }
        if (ele.getAttributeNode("TargetType") != null) {
            targType = VWAssociationTargetType.stringToType(ele.getAttribute("TargetType"));
        }
        VWAssociationDefinition theAssociation = annotation.internalCreateAssociation(targId, targType);
        if (ele.getAttributeNode("Name") != null) {
            theAssociation.setName(ele.getAttribute("Name"));
        }
    }

    protected static void parseXMLStepDefinition(Node aNode, VWMapDefinition map, VWStepPaletteDefinition spDef) throws VWException, SAXException {
        VWStepDefinition step = null;
        VWArrayHandler partHandler = new VWArrayHandler(1, 1);
        VWArrayHandler responseHandler = new VWArrayHandler(1, 1);
        Element ele = (Element)aNode;
        if (map != null) {
            step = map.createEmptyStep();
        } else if (spDef != null) {
            step = spDef.createEmptyStep();
        }
        if (ele.getAttributeNode("Name") != null) {
            step.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("StepId") != null) {
            step.setStepId(Integer.parseInt(ele.getAttribute("StepId")));
        }
        if (ele.getAttributeNode("Description") != null) {
            step.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("Documentation") != null) {
            step.setDocumentation(ele.getAttribute("Documentation"));
        }
        if (ele.getAttributeNode("QueueName") != null) {
            step.setQueueName(ele.getAttribute("QueueName"));
        }
        if (ele.getAttributeNode("OperationName") != null) {
            step.setOperationName(ele.getAttribute("OperationName"));
        }
        if (ele.getAttributeNode("PreMilestone") != null && map != null) {
            step.setPreMilestone(ele.getAttribute("PreMilestone"));
        }
        if (ele.getAttributeNode("PostMilestone") != null && map != null) {
            step.setPostMilestone(ele.getAttribute("PostMilestone"));
        }
        if (ele.getAttributeNode("RequestedInterface") != null) {
            step.setRequestedInterface(ele.getAttribute("RequestedInterface"));
        }
        if (ele.getAttributeNode("JoinStepId") != null) {
            step.setJoinStepId(Integer.parseInt(ele.getAttribute("JoinStepId")));
        }
        if (ele.getAttributeNode("JoinType") != null) {
            step.setJoinType(VWJoinType.stringToType(ele.getAttribute("JoinType")));
        }
        if (ele.getAttributeNode("SplitType") != null) {
            step.setSplitType(VWSplitType.stringToType(ele.getAttribute("SplitType")));
        }
        if (ele.getAttributeNode("CanReassign") != null) {
            step.setCanReassign(VWXMLHandler.stringToBoolean(ele.getAttribute("CanReassign")));
        }
        if (ele.getAttributeNode("CanViewStatus") != null) {
            step.setCanViewStatus(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewStatus")));
        }
        if (ele.getAttributeNode("CanViewHistory") != null) {
            step.setCanViewHistory(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewHistory")));
        }
        if (ele.getAttributeNode("IgnoreInvalidUsers") != null) {
            step.setIgnoreInvalidUsers(VWXMLHandler.stringToBoolean(ele.getAttribute("IgnoreInvalidUsers")));
        }
        if (ele.getAttributeNode("Deadline") != null) {
            step.setDeadlineExpr(ele.getAttribute("Deadline"));
        }
        if (ele.getAttributeNode("DeadlineMap") != null) {
            step.setDeadlineMap(ele.getAttribute("DeadlineMap"));
        }
        if (ele.getAttributeNode("Reminder") != null) {
            step.setReminder(Long.parseLong(ele.getAttribute("Reminder")));
        }
        String xcoordStr = null;
        String ycoordStr = null;
        if (ele.getAttributeNode("XCoordinate") != null) {
            xcoordStr = ele.getAttribute("XCoordinate");
        }
        if (ele.getAttributeNode("YCoordinate") != null) {
            ycoordStr = ele.getAttribute("YCoordinate");
        }
        if (xcoordStr != null && ycoordStr != null) {
            step.setLocation(new Point(Integer.parseInt(xcoordStr), Integer.parseInt(ycoordStr)));
        }
        NodeList childNodes = aNode.getChildNodes();
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            String childNodeName = childNode.getNodeName();
            if (childNodeName.equals("Participant")) {
                step.setParticipants((VWParticipant[])partHandler.addElementToArray(step.getParticipants(), new VWParticipant(((Element)childNode).getAttribute("Val"))));
                continue;
            }
            if (childNodeName.equals("Response")) {
                step.setResponses((String[])responseHandler.addElementToArray(step.getResponses(), ((Element)childNode).getAttribute("Val")));
                continue;
            }
            if (childNodeName.equals("PreAssignments") || childNodeName.equals("PostAssignments")) {
                if (!childNode.hasChildNodes()) continue;
                NodeList assignNodes = childNode.getChildNodes();
                int childNodeCount = assignNodes.getLength();
                int AssignCount = 0;
                for (int k = 0; k < childNodeCount; ++k) {
                    if (assignNodes.item(k).getNodeType() != 1) continue;
                    ++AssignCount;
                }
                String[][] Assignments = new String[AssignCount][2];
                int assignIndex = 0;
                for (int j = 0; j < childNodeCount; ++j) {
                    Node asNode = assignNodes.item(j);
                    if (assignNodes.item(j).getNodeType() != 1 || !assignNodes.item(j).getNodeName().equals("Assign")) continue;
                    Assignments[assignIndex][0] = ((Element)asNode).getAttribute("LVal");
                    Assignments[assignIndex][1] = ((Element)asNode).getAttribute("RVal");
                    ++assignIndex;
                }
                if (childNodeName.equals("PreAssignments")) {
                    step.setPreAssignments(Assignments);
                    continue;
                }
                step.setPostAssignments(Assignments);
                continue;
            }
            if (childNodeName.equals("ModelAttributes")) {
                Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(childNode);
                step.setAttributes(attributes);
                continue;
            }
            if (childNodeName.equals("Parameter")) {
                VWXML_CUR_parser.parseXMLParameterDefinition(childNode, step);
                continue;
            }
            if (childNodeName.equals("Route") && map != null) {
                VWXML_CUR_parser.parseXMLRouteDefinition(childNode, map);
                continue;
            }
            if (childNodeName.equals("StepOperation")) {
                VWXML_CUR_parser.parseXMLStepOperation(childNode, step);
                continue;
            }
            if (childNode.getNodeName().equals("PreRule") && map != null) {
                VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 0);
                continue;
            }
            if (childNode.getNodeName().equals("UpdateRule") && map != null) {
                VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 1);
                continue;
            }
            if (!childNode.getNodeName().equals("PostRule") || map == null) continue;
            VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 2);
        }
    }

    static void parseXMLStepOperation(Node childNode, VWStepDefinition step) throws VWException {
        Element opEle = (Element)childNode;
        step.setOperationName(opEle.getAttribute("Name"));
        if (childNode.hasChildNodes()) {
            NodeList opChildNodes = childNode.getChildNodes();
            int childNodeCount = opChildNodes.getLength();
            int opParamCount = 0;
            for (int n = 0; n < childNodeCount; ++n) {
                if (opChildNodes.item(n).getNodeType() != 1) continue;
                ++opParamCount;
            }
            String[] opParams = new String[opParamCount];
            int paramIndex = 0;
            for (int k = 0; k < opChildNodes.getLength(); ++k) {
                Node opParamChildNode = opChildNodes.item(k);
                if (opParamChildNode.getNodeType() != 1) continue;
                opParams[paramIndex] = ((Element)opParamChildNode).getAttribute("Val");
                ++paramIndex;
            }
            step.setOperationParameters(opParams);
        }
    }

    protected static void parseXMLCompoundStepDefinition(Node aNode, VWMapDefinition map, VWStepPaletteDefinition spDef) throws VWException, SAXException {
        VWCompoundStepDefinition compStep = null;
        Element ele = (Element)aNode;
        if (map != null) {
            compStep = map.createEmptyCompoundStep();
        } else if (spDef != null) {
            compStep = spDef.createEmptyCompoundStep();
        }
        if (ele.getAttributeNode("Name") != null) {
            compStep.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("StepId") != null) {
            compStep.setStepId(Integer.parseInt(ele.getAttribute("StepId")));
        }
        if (ele.getAttributeNode("Description") != null) {
            compStep.setDescription(ele.getAttribute("Description"));
        }
        if (ele.getAttributeNode("Documentation") != null) {
            compStep.setDocumentation(ele.getAttribute("Documentation"));
        }
        String xcoordStr = null;
        String ycoordStr = null;
        if (ele.getAttributeNode("XCoordinate") != null) {
            xcoordStr = ele.getAttribute("XCoordinate");
        }
        if (ele.getAttributeNode("YCoordinate") != null) {
            ycoordStr = ele.getAttribute("YCoordinate");
        }
        if (xcoordStr != null && ycoordStr != null) {
            compStep.setLocation(new Point(Integer.parseInt(xcoordStr), Integer.parseInt(ycoordStr)));
        }
        if (ele.getAttributeNode("JoinStepId") != null) {
            compStep.setJoinStepId(Integer.parseInt(ele.getAttribute("JoinStepId")));
        }
        if (ele.getAttributeNode("JoinType") != null) {
            compStep.setJoinType(VWJoinType.stringToType(ele.getAttribute("JoinType")));
        }
        if (ele.getAttributeNode("SplitType") != null) {
            compStep.setSplitType(VWSplitType.stringToType(ele.getAttribute("SplitType")));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Instruction")) {
                VWXML_CUR_parser.parseXMLSimpleInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("RBInstruction")) {
                VWXML_CUR_parser.parseXMLRBInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("WFEInstruction")) {
                VWXML_CUR_parser.parseXMLWFEInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("invoke")) {
                VWXML_CUR_parser.parseXMLInvokeInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("receive")) {
                VWXML_CUR_parser.parseXMLReceiveInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("reply")) {
                VWXML_CUR_parser.parseXMLReplyInstructionDefinition(childNode, compStep);
                continue;
            }
            if (childNode.getNodeName().equals("Route") && map != null) {
                VWXML_CUR_parser.parseXMLRouteDefinition(childNode, map);
                continue;
            }
            if (childNode.getNodeName().equals("PreRule") && map != null) {
                VWXML_CUR_parser.parseXMLStepRulesList(childNode, compStep, 0);
                continue;
            }
            if (childNode.getNodeName().equals("PostRule") && map != null) {
                VWXML_CUR_parser.parseXMLStepRulesList(childNode, compStep, 2);
                continue;
            }
            if (!childNode.getNodeName().equals("ModelAttributes")) continue;
            Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(childNode);
            compStep.setAttributes(attributes);
        }
    }

    protected static void parseXMLSimpleInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        VWArrayHandler paramHandler = new VWArrayHandler(1, 1);
        String[] params = null;
        Element ele = (Element)aNode;
        VWInstructionDefinition newIns = compStep.createEmptyInstruction();
        if (ele.getAttributeNode("Id") != null) {
            newIns.setInstructionId(Integer.parseInt(ele.getAttribute("Id")));
        }
        if (ele.getAttributeNode("Action") != null) {
            newIns.setAction(VWActionType.stringToType(ele.getAttribute("Action")));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Expression") && !childNode.getNodeName().equals("fn:Expression")) continue;
            params = (String[])paramHandler.addElementToArray(params, ((Element)childNode).getAttribute("Val"));
        }
        if (params != null) {
            ((VWSimpleInstruction)newIns).setParams((String[])paramHandler.getElements(params));
        }
    }

    protected static void parseXMLRBInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        VWArrayHandler paramHandler = new VWArrayHandler(1, 1);
        String[] params = null;
        String compCallStr = null;
        int instId = -1;
        String reDoExprStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("CompCall") != null) {
            compCallStr = ele.getAttribute("CompCall");
        }
        if (ele.getAttributeNode("ReDo") != null) {
            reDoExprStr = ele.getAttribute("ReDo");
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Expression")) continue;
            params = (String[])paramHandler.addElementToArray(params, ((Element)childNode).getAttribute("Val"));
        }
        VWInstructionDefinition newIns = compStep.createRollbackCheckpointInstruction(reDoExprStr, compCallStr, params);
        newIns.setInstructionId(instId);
    }

    protected static void parseXMLWFEInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        String timeOutExprStr = null;
        int instId = -1;
        String eventNumLocLValueStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("TimeOut") != null) {
            timeOutExprStr = ele.getAttribute("TimeOut");
        }
        if (ele.getAttributeNode("EventNumLoc") != null) {
            eventNumLocLValueStr = ele.getAttribute("EventNumLoc");
        }
        VWInstructionDefinition newIns = compStep.createWFEInstruction(timeOutExprStr, eventNumLocLValueStr);
        newIns.setInstructionId(instId);
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("Event") && !childNode.getNodeName().equals("fn:Event")) continue;
            VWXML_CUR_parser.parseXMLEventDefinition(childNode, (VWWFEInstruction)newIns);
        }
    }

    protected static void parseXMLInvokeInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        String partnerLinkNameStr = null;
        int instId = -1;
        String operationNameStr = null;
        String inputVariableExprStr = null;
        String outputVariableExprStr = null;
        String inputVariableNameStr = null;
        String outputVariableNameStr = null;
        String timeOutExprStr = null;
        String timeOutMapStr = null;
        boolean useRelMess = false;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("partnerLink") != null) {
            partnerLinkNameStr = ele.getAttribute("partnerLink");
        }
        if (ele.getAttributeNode("operation") != null) {
            operationNameStr = ele.getAttribute("operation");
        }
        if (ele.getAttributeNode("inputVariable") != null) {
            inputVariableExprStr = ele.getAttribute("inputVariable");
        }
        if (ele.getAttributeNode("outputVariable") != null) {
            outputVariableExprStr = ele.getAttribute("outputVariable");
        }
        if (ele.getAttributeNode("inputVariableName") != null) {
            inputVariableNameStr = ele.getAttribute("inputVariableName");
        }
        if (ele.getAttributeNode("outputVariableName") != null) {
            outputVariableNameStr = ele.getAttribute("outputVariableName");
        }
        if (ele.getAttributeNode("timeout") != null) {
            timeOutExprStr = ele.getAttribute("timeout");
        }
        if (ele.getAttributeNode("timeoutMap") != null) {
            timeOutMapStr = ele.getAttribute("timeoutMap");
        }
        if (ele.getAttributeNode("useReliableMessaging") != null) {
            useRelMess = VWXMLHandler.stringToBoolean(ele.getAttribute("useReliableMessaging"));
        }
        VWInstructionDefinition newIns = compStep.createInvokeInstruction(partnerLinkNameStr, operationNameStr);
        newIns.setInstructionId(instId);
        ((VWInvokeInstruction)newIns).setInputMsgExpr(inputVariableExprStr);
        ((VWInvokeInstruction)newIns).setOutputMsgExpr(outputVariableExprStr);
        ((VWInvokeInstruction)newIns).setInputMsgName(inputVariableNameStr);
        ((VWInvokeInstruction)newIns).setOutputMsgName(outputVariableNameStr);
        ((VWInvokeInstruction)newIns).setTimeoutExpr(timeOutExprStr);
        ((VWInvokeInstruction)newIns).setTimeoutMapName(timeOutMapStr);
        ((VWInvokeInstruction)newIns).setUseReliableMessaging(useRelMess);
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            CorrSet cs;
            int j;
            NodeList subNodes;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("catch")) {
                VWXML_CUR_parser.parseXMLFaultDefinition(childNode, (VWInvokeInstruction)newIns, false);
            }
            if (childNode.getNodeName().equals("catchAll") && childNode.hasChildNodes()) {
                NodeList attribNodes = childNode.getChildNodes();
                int childNodeCount = attribNodes.getLength();
                for (int j2 = 0; j2 < childNodeCount; ++j2) {
                    Node asNode = attribNodes.item(j2);
                    if (asNode.getNodeType() != 1 || !asNode.getNodeName().equals("catch")) continue;
                    VWXML_CUR_parser.parseXMLFaultDefinition(asNode, (VWInvokeInstruction)newIns, true);
                }
            }
            if (childNode.getNodeName().equals("InComingParameters")) {
                subNodes = childNode.getChildNodes();
                for (j = 0; j < subNodes.getLength(); ++j) {
                    Node subNode = subNodes.item(j);
                    if (!subNode.getNodeName().equals("WSParameter")) continue;
                    VWXML_CUR_parser.parseXMLWebServiceParameterDefinition(subNode, (IVWHasWSParameterDefs)((Object)newIns), 1);
                }
            }
            if (childNode.getNodeName().equals("OutGoingParameters")) {
                subNodes = childNode.getChildNodes();
                for (j = 0; j < subNodes.getLength(); ++j) {
                    Node subNode = subNodes.item(j);
                    if (!subNode.getNodeName().equals("WSParameter")) continue;
                    VWXML_CUR_parser.parseXMLWebServiceParameterDefinition(subNode, (IVWHasWSParameterDefs)((Object)newIns), 2);
                }
            }
            if (childNode.getNodeName().equals("inputCorrelationSet")) {
                subNodes = childNode.getChildNodes();
                for (j = 0; j < subNodes.getLength(); ++j) {
                    Node subNode = subNodes.item(j);
                    if (!subNode.getNodeName().equals("correlationSet") || (cs = VWXML_CUR_parser.parseXMLCorrelationSet(subNode)) == null) continue;
                    ((VWInvokeInstruction)newIns).setInputCorrelationSetName(cs.getName());
                    ((VWInvokeInstruction)newIns).setInputCorrelationSetProperties(cs.getProperties());
                }
            }
            if (!childNode.getNodeName().equals("outputCorrelationSet")) continue;
            subNodes = childNode.getChildNodes();
            for (j = 0; j < subNodes.getLength(); ++j) {
                Node subNode = subNodes.item(j);
                if (!subNode.getNodeName().equals("correlationSet") || (cs = VWXML_CUR_parser.parseXMLCorrelationSet(subNode)) == null) continue;
                ((VWInvokeInstruction)newIns).setOutputCorrelationSetName(cs.getName());
                ((VWInvokeInstruction)newIns).setOutputCorrelationSetProperties(cs.getProperties());
            }
        }
    }

    protected static void parseXMLReceiveInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        String partnerLinkNameStr = null;
        int instId = -1;
        int onlineId = -1;
        String operationNameStr = null;
        String messageExprStr = null;
        String messageFromSchemaStr = null;
        String messageFromElementStr = null;
        String timeOutExprStr = null;
        String timeOutMapStr = null;
        boolean authenticationFlag = false;
        int CorrSetParamSequenceNumber = -1;
        String CorrSetValueExprStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("OnlineId") != null) {
            onlineId = Integer.parseInt(ele.getAttribute("OnlineId"));
        }
        if (ele.getAttributeNode("partnerLink") != null) {
            partnerLinkNameStr = ele.getAttribute("partnerLink");
        }
        if (ele.getAttributeNode("operation") != null) {
            operationNameStr = ele.getAttribute("operation");
        }
        if (ele.getAttributeNode("message") != null) {
            messageExprStr = ele.getAttribute("message");
        }
        if (ele.getAttributeNode("messageFromSchema") != null) {
            messageFromSchemaStr = ele.getAttribute("messageFromSchema");
        }
        if (ele.getAttributeNode("messageFromElement") != null) {
            messageFromElementStr = ele.getAttribute("messageFromElement");
        }
        if (ele.getAttributeNode("timeout") != null) {
            timeOutExprStr = ele.getAttribute("timeout");
        }
        if (ele.getAttributeNode("timeoutMap") != null) {
            timeOutMapStr = ele.getAttribute("timeoutMap");
        }
        if (ele.getAttributeNode("authentication") != null) {
            authenticationFlag = VWXMLHandler.stringToBoolean(ele.getAttribute("authentication"));
        }
        if (ele.getAttributeNode("correlationParameterSequenceNumber") != null) {
            CorrSetParamSequenceNumber = Integer.parseInt(ele.getAttribute("correlationParameterSequenceNumber"));
        }
        if (ele.getAttributeNode("correlationValueExpression") != null) {
            CorrSetValueExprStr = ele.getAttribute("correlationValueExpression");
        }
        VWInstructionDefinition newIns = compStep.createReceiveInstruction(partnerLinkNameStr, operationNameStr);
        newIns.setInstructionId(instId);
        ((VWReceiveInstruction)newIns).setOnlineId(onlineId);
        ((VWReceiveInstruction)newIns).setMessageExpr(messageExprStr);
        ((VWReceiveInstruction)newIns).setMessageFromSchemaName(messageFromSchemaStr);
        ((VWReceiveInstruction)newIns).setMessageFromElementName(messageFromElementStr);
        ((VWReceiveInstruction)newIns).setTimeoutExpr(timeOutExprStr);
        ((VWReceiveInstruction)newIns).setTimeoutMapName(timeOutMapStr);
        ((VWReceiveInstruction)newIns).setAuthentication(authenticationFlag);
        ((VWReceiveInstruction)newIns).setCorrelationParameterSequenceNumber(CorrSetParamSequenceNumber);
        ((VWReceiveInstruction)newIns).setCorrelationValueExpression(CorrSetValueExprStr);
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            NodeList childNodesSG;
            CorrSet cs;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("WSParameter")) {
                VWXML_CUR_parser.parseXMLWebServiceParameterDefinition(childNode, (IVWHasWSParameterDefs)((Object)newIns), 0);
            }
            if (childNode.getNodeName().equals("correlationSet") && (cs = VWXML_CUR_parser.parseXMLCorrelationSet(childNode)) != null) {
                ((VWReceiveInstruction)newIns).setCorrelationSetName(cs.getName());
                ((VWReceiveInstruction)newIns).setCorrelationSetProperties(cs.getProperties());
            }
            if (!childNode.getNodeName().equals("securityGroup") || (childNodesSG = childNode.getChildNodes()).getLength() <= 0) continue;
            Vector<String> secGrpVector = new Vector<String>();
            for (int j = 0; j < childNodesSG.getLength(); ++j) {
                Node childNodeSG = childNodesSG.item(j);
                if (!childNodeSG.getNodeName().equals("Expression")) continue;
                Element eleSG = (Element)childNodeSG;
                String sgExpr = null;
                if (eleSG.getAttributeNode("Val") != null) {
                    sgExpr = eleSG.getAttribute("Val");
                }
                if (sgExpr == null) continue;
                secGrpVector.add(sgExpr);
            }
            ((VWReceiveInstruction)newIns).setSecurityGroup(secGrpVector.toArray(new String[0]));
        }
    }

    protected static void parseXMLReplyInstructionDefinition(Node aNode, VWCompoundStepDefinition compStep) throws VWException, SAXException {
        String partnerLinkNameStr = null;
        int instId = -1;
        String operationNameStr = null;
        String faultNameStr = null;
        String messageExprStr = null;
        String messageFromSchemaStr = null;
        String messageFromElementStr = null;
        boolean hasAttachmentsFlag = false;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            instId = Integer.parseInt(ele.getAttribute("Id"));
        }
        if (ele.getAttributeNode("partnerLink") != null) {
            partnerLinkNameStr = ele.getAttribute("partnerLink");
        }
        if (ele.getAttributeNode("operation") != null) {
            operationNameStr = ele.getAttribute("operation");
        }
        if (ele.getAttributeNode("message") != null) {
            messageExprStr = ele.getAttribute("message");
        }
        if (ele.getAttributeNode("messageFromSchema") != null) {
            messageFromSchemaStr = ele.getAttribute("messageFromSchema");
        }
        if (ele.getAttributeNode("messageFromElement") != null) {
            messageFromElementStr = ele.getAttribute("messageFromElement");
        }
        if (ele.getAttributeNode("faultName") != null) {
            faultNameStr = ele.getAttribute("faultName");
        }
        if (ele.getAttributeNode("hasAttachments") != null) {
            hasAttachmentsFlag = VWXMLHandler.stringToBoolean(ele.getAttribute("hasAttachments"));
        }
        VWInstructionDefinition newIns = compStep.createReplyInstruction(partnerLinkNameStr, operationNameStr);
        newIns.setInstructionId(instId);
        ((VWReplyInstruction)newIns).setMessageExpr(messageExprStr);
        ((VWReplyInstruction)newIns).setMessageFromSchemaName(messageFromSchemaStr);
        ((VWReplyInstruction)newIns).setMessageFromElementName(messageFromElementStr);
        ((VWReplyInstruction)newIns).setFaultName(faultNameStr);
        ((VWReplyInstruction)newIns).setHasAttachments(hasAttachmentsFlag);
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            CorrSet cs;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("WSParameter")) {
                VWXML_CUR_parser.parseXMLWebServiceParameterDefinition(childNode, (IVWHasWSParameterDefs)((Object)newIns), 0);
            }
            if (!childNode.getNodeName().equals("correlationSet") || (cs = VWXML_CUR_parser.parseXMLCorrelationSet(childNode)) == null) continue;
            ((VWReplyInstruction)newIns).setCorrelationSetName(cs.getName());
            ((VWReplyInstruction)newIns).setCorrelationSetProperties(cs.getProperties());
        }
    }

    protected static CorrSet parseXMLCorrelationSet(Node aNode) throws VWException, SAXException, NumberFormatException {
        CorrSet retCorrSet = new CorrSet();
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("name") != null) {
            retCorrSet.setName(ele.getAttribute("name"));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals("property")) continue;
            Element childEle = (Element)childNode;
            if (childEle.getAttributeNode("name") != null) {
                retCorrSet.addPropName(childEle.getAttribute("name"));
            }
            if (childEle.getAttributeNode("query") == null) continue;
            retCorrSet.addPropQuery(childEle.getAttribute("query"));
        }
        return retCorrSet;
    }

    protected static void parseXMLEventDefinition(Node aNode, VWWFEInstruction theWFEInst) throws VWException, SAXException, NumberFormatException {
        String wcNameStr = null;
        String opStr = null;
        String valueStr = null;
        String callISStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("WCName") != null) {
            wcNameStr = ele.getAttribute("WCName");
        }
        if (ele.getAttributeNode("Operator") != null) {
            opStr = ele.getAttribute("Operator");
        }
        if (ele.getAttributeNode("Value") != null) {
            valueStr = ele.getAttribute("Value");
        }
        if (ele.getAttributeNode("CallIS") != null) {
            callISStr = ele.getAttribute("CallIS");
        }
        VWEventDefinition newEvent = theWFEInst.createEvent();
        newEvent.setWorkClassName(wcNameStr);
        newEvent.setComparisonOperator(opStr);
        newEvent.setValue(valueStr);
        newEvent.setCallISName(callISStr);
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes.getLength() > 0) {
            Vector<String[]> assignsFromXML_vect = new Vector<String[]>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childNode.getNodeName().equals("Assign") && !childNode.getNodeName().equals("fn:Assign")) continue;
                String[] tmpA = new String[2];
                ele = (Element)childNode;
                if (ele.getAttributeNode("LVal") != null) {
                    tmpA[0] = ele.getAttribute("LVal");
                }
                if (ele.getAttributeNode("RVal") != null) {
                    tmpA[1] = ele.getAttribute("RVal");
                }
                assignsFromXML_vect.addElement(tmpA);
            }
            String[][] tmpAssignArray = new String[assignsFromXML_vect.size()][2];
            assignsFromXML_vect.copyInto((Object[])tmpAssignArray);
            newEvent.setAssignments(tmpAssignArray);
        }
    }

    protected static void parseXMLFaultDefinition(Node aNode, VWInvokeInstruction theInvokeInst, boolean catchall) throws VWException, SAXException, NumberFormatException {
        String nameStr = null;
        String faultMapNameStr = null;
        String faultMessageStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("faultName") != null) {
            nameStr = ele.getAttribute("faultName");
        }
        if (ele.getAttributeNode("faultMap") != null) {
            faultMapNameStr = ele.getAttribute("faultMap");
        }
        if (ele.getAttributeNode("faultVariable") != null) {
            faultMessageStr = ele.getAttribute("faultVariable");
        }
        if (catchall) {
            theInvokeInst.setCatchAllMap(faultMapNameStr);
            theInvokeInst.setCatchAllOutput(faultMessageStr);
        } else {
            theInvokeInst.createFault(nameStr, faultMessageStr, faultMapNameStr);
        }
    }

    protected static void parseXMLRouteDefinition(Node aNode, VWMapDefinition map) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String condition = null;
        int routeid = -1;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("Condition") != null) {
            condition = ele.getAttribute("Condition");
        }
        VWMapNode step = map.getStep(Integer.parseInt(ele.getAttribute("SourceStepId")));
        VWRouteDefinition aRoute = null;
        if (ele.getAttributeNode("RouteId") != null) {
            routeid = Integer.parseInt(ele.getAttribute("RouteId"));
            aRoute = step.createRoute(routeid, Integer.parseInt(ele.getAttribute("DestinationStepId")), condition, name);
        } else {
            aRoute = step.createRoute(Integer.parseInt(ele.getAttribute("DestinationStepId")), condition, name);
        }
        if (ele.getAttributeNode("Release") != null) {
            aRoute.setRelease(VWXMLHandler.stringToBoolean(ele.getAttribute("Release")));
        }
        if (ele.getAttributeNode("Description") != null) {
            aRoute.setDescription(ele.getAttribute("Description"));
        }
        NodeList childNodes = aNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            String childNodeName = childNode.getNodeName();
            if (!childNodeName.equals("ModelAttributes")) continue;
            Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(childNode);
            aRoute.setAttributes(attributes);
        }
    }

    protected static void parseXMLParameterDefinition(Node aNode, IVWCanCreateParameters step) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String valueStr = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        VWParameterDefinition param = step.createParameter(name, VWModeType.stringToType(ele.getAttribute("Mode")), valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray")));
        if (ele.getAttributeNode("Description") != null) {
            param.setDescription(ele.getAttribute("Description"));
        }
    }

    protected static void parseXMLWebServiceParameterDefinition(Node aNode, IVWHasWSParameterDefs inst, int indicator) throws VWException, SAXException, NumberFormatException {
        String name = null;
        String valueStr = null;
        VWWebServiceParameterDefinition param = null;
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Name") != null) {
            name = ele.getAttribute("Name");
        }
        if (ele.getAttributeNode("ValueExpr") != null) {
            valueStr = ele.getAttribute("ValueExpr");
        }
        if (inst instanceof VWReceiveInstruction) {
            param = ((VWReceiveInstruction)inst).createParameter(name, valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray")));
        } else if (inst instanceof VWReplyInstruction) {
            param = ((VWReplyInstruction)inst).createParameter(name, valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray")));
        } else if (inst instanceof VWInvokeInstruction) {
            param = indicator == 1 ? ((VWInvokeInstruction)inst).createInComingParameter(name, valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray"))) : ((VWInvokeInstruction)inst).createOutGoingParameter(name, valueStr, VWFieldType.stringToType(ele.getAttribute("Type")), VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray")));
        }
        if (ele.getAttributeNode("NameSpace") != null) {
            param.setNameSpace(ele.getAttributeNode("NameSpace").getValue());
        }
        if (ele.getAttributeNode("Attributes") != null) {
            param.setAttributes(ele.getAttributeNode("Attributes").getValue());
        }
        if (ele.getAttributeNode("ArrayTag") != null) {
            param.setArrayTag(ele.getAttributeNode("ArrayTag").getValue());
        }
        if (ele.getAttributeNode("ArrayNameSpace") != null) {
            param.setArrayNameSpace(ele.getAttributeNode("ArrayNameSpace").getValue());
        }
        if (ele.getAttributeNode("ArrayAttributes") != null) {
            param.setArrayAttributes(ele.getAttributeNode("ArrayAttributes").getValue());
        }
        if (ele.getAttributeNode("LexicalLevel") != null) {
            param.setLexicalLevel(Integer.parseInt(ele.getAttributeNode("LexicalLevel").getValue()));
        }
        if (ele.getAttributeNode("Sequence") != null) {
            param.setSequenceNumber(Integer.parseInt(ele.getAttributeNode("Sequence").getValue()));
        }
        if (ele.getAttributeNode("AttachmentByValue") != null) {
            param.setAttachmentByValue(VWXMLHandler.stringToBoolean(ele.getAttributeNode("AttachmentByValue").getValue()));
        }
        if (ele.getAttributeNode("SchemaSubType") != null) {
            param.setSchemaSubType(VWXMLSchemaSubType.stringToType(ele.getAttributeNode("SchemaSubType").getValue()));
        }
    }

    protected static Hashtable parseXMLModelAttributes(Node aNode) throws VWException, SAXException, NumberFormatException {
        Hashtable<String, Object> ModelAttributes = null;
        Vector<Object> arrayElementsFromXML_vect = null;
        if (aNode.hasChildNodes()) {
            NodeList attribNodes = aNode.getChildNodes();
            int childNodeCount = attribNodes.getLength();
            ModelAttributes = new Hashtable<String, Object>();
            String keyValue = null;
            boolean isArray = false;
            for (int j = 0; j < childNodeCount; ++j) {
                Node asNode = attribNodes.item(j);
                if (attribNodes.item(j).getNodeType() != 1 || attribNodes.item(j).getNodeName() != "ModelAttribute") continue;
                keyValue = ((Element)asNode).getAttribute("Name");
                isArray = VWXMLHandler.stringToBoolean(((Element)asNode).getAttribute("IsArray"));
                String typeString = ((Element)asNode).getAttribute("Type");
                int typeInt = VWFieldType.stringToType(typeString);
                NodeList valChildNodes = asNode.getChildNodes();
                if (valChildNodes.getLength() > 0) {
                    arrayElementsFromXML_vect = new Vector<Object>();
                    for (int i = 0; i < valChildNodes.getLength(); ++i) {
                        Node childNode = valChildNodes.item(i);
                        if (!childNode.getNodeName().equals("Value")) continue;
                        Element ele = (Element)childNode;
                        String valueStr = ele.getAttribute("Val");
                        Object val = null;
                        switch (typeInt) {
                            case 1: {
                                val = new Integer(valueStr);
                                break;
                            }
                            case 8: {
                                val = new Double(valueStr);
                                break;
                            }
                            case 4: {
                                val = Boolean.valueOf(valueStr);
                                break;
                            }
                            case 16: {
                                val = VWXMLUtil.convertUTCStringToDate(valueStr);
                                break;
                            }
                            case 2: {
                                if (valueStr != null) {
                                    val = valueStr;
                                    break;
                                }
                                val = null;
                                break;
                            }
                            case 512: {
                                val = new VWGuid(valueStr);
                                break;
                            }
                            default: {
                                throw new VWException("vw.api.VWXMLHandlerAttributeBadType", "integer form of the field type is invalid: {0}", String.valueOf(typeInt));
                            }
                        }
                        arrayElementsFromXML_vect.addElement(val);
                    }
                }
                if (!isArray) {
                    if (arrayElementsFromXML_vect.size() != 1) {
                        throw new VWException("vw.api.VWSimpleTypeMultipleValues", "Non-array attribute should only have one value, found {0}", String.valueOf(arrayElementsFromXML_vect.size()));
                    }
                    ModelAttributes.put(keyValue, arrayElementsFromXML_vect.elementAt(0));
                    continue;
                }
                Object[] tmpArray = null;
                switch (typeInt) {
                    case 1: {
                        tmpArray = new Integer[arrayElementsFromXML_vect.size()];
                        break;
                    }
                    case 8: {
                        tmpArray = new Double[arrayElementsFromXML_vect.size()];
                        break;
                    }
                    case 4: {
                        tmpArray = new Boolean[arrayElementsFromXML_vect.size()];
                        break;
                    }
                    case 16: {
                        tmpArray = new Date[arrayElementsFromXML_vect.size()];
                        break;
                    }
                    case 2: {
                        tmpArray = new String[arrayElementsFromXML_vect.size()];
                        break;
                    }
                    case 512: {
                        tmpArray = new VWGuid[arrayElementsFromXML_vect.size()];
                        break;
                    }
                    default: {
                        throw new VWException("vw.api.VWXMLHandlerAttributeBadTypeForArray", "integer form of the field type is invalid: {0}", String.valueOf(typeInt));
                    }
                }
                arrayElementsFromXML_vect.copyInto(tmpArray);
                ModelAttributes.put(keyValue, tmpArray);
            }
        }
        return ModelAttributes;
    }

    protected static void parseXMLRuntimeId(Node aNode, VWWorkflowDefinition wfdef) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String serviceName = null;
        String id = null;
        Date timeStamp = null;
        int region = -1;
        int wcId = -1;
        int wcRevision = -1;
        int wsId = -1;
        int WSDLVersion = 0;
        if (ele.getAttributeNode("ServiceName") != null) {
            serviceName = ele.getAttribute("ServiceName");
        }
        if (ele.getAttributeNode("IsolatedRegion") != null) {
            region = Integer.parseInt(ele.getAttribute("IsolatedRegion"));
        }
        if (ele.getAttributeNode("IRTimeStamp") != null) {
            try {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
                timeStamp = dateFormatter.parse(ele.getAttribute("IRTimeStamp"));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (ele.getAttributeNode("WorkClassId") != null) {
            wcId = Integer.parseInt(ele.getAttribute("WorkClassId"));
        }
        if (ele.getAttributeNode("WCRevision") != null) {
            wcRevision = Integer.parseInt(ele.getAttribute("WCRevision"));
        }
        if (ele.getAttributeNode("Id") != null) {
            id = ele.getAttribute("Id");
        }
        if (ele.getAttributeNode("WorkSpaceId") != null) {
            wsId = Integer.parseInt(ele.getAttribute("WorkSpaceId"));
        }
        if (ele.getAttributeNode("WSDLVersion") != null) {
            WSDLVersion = Integer.parseInt(ele.getAttribute("WSDLVersion"));
        }
        wfdef.setRuntimeId(new VWWorkflowRuntimeId(serviceName, region, timeStamp, wcId, wcRevision, id, wsId, WSDLVersion));
    }

    protected static void parseXMLStepRulesList(Node aNode, VWMapNode aStep, int RuleSetSelector) throws VWException {
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes.getLength() > 0) {
            Vector<String> ruleVector = new Vector<String>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childNode.getNodeName().equals("Expression")) continue;
                Element ele = (Element)childNode;
                String rsName = null;
                if (ele.getAttributeNode("Val") != null) {
                    rsName = ele.getAttribute("Val");
                }
                int idx = -1;
                try {
                    if (rsName != null) {
                        idx = Integer.parseInt(rsName);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (idx != -1) {
                    try {
                        rsName = aStep.getMap().getWorkflow().getRuleSetNameFromIndex(idx);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (rsName == null) continue;
                ruleVector.add(rsName);
            }
            aStep.setRuleSets(RuleSetSelector, ruleVector.toArray(new String[0]));
        }
    }

    protected static VWStepPaletteDefinition parseXMLStepPalette(Element spele) throws VWException, SAXException {
        if (!spele.getTagName().equals("StepPaletteDefinition")) {
            return null;
        }
        VWStepPaletteDefinition spdef = new VWStepPaletteDefinition();
        if (spele.getAttributeNode("Name") != null) {
            spdef.setName(spele.getAttribute("Name"));
        }
        if (spele.getAttributeNode("Description") != null) {
            spdef.setDescription(spele.getAttribute("Description"));
        }
        NodeList childNodes = spele.getChildNodes();
        int numChilds = 0;
        if (childNodes != null) {
            numChilds = childNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equals("Step")) {
                VWXML_CUR_parser.parseXMLStepDefinition(childNode, null, spdef);
                continue;
            }
            if (!childNode.getNodeName().equals("CompoundStep")) continue;
            VWXML_CUR_parser.parseXMLCompoundStepDefinition(childNode, null, spdef);
        }
        if (spele.getAttributeNode("MaxStepId") != null) {
            int maxStepId = Integer.parseInt(spele.getAttribute("MaxStepId"));
            if (maxStepId >= spdef.findHighestStepId()) {
                spdef.getStepIdGenerator().setNextId(maxStepId + 1);
            } else {
                spdef.updateNextStepId();
            }
        } else {
            spdef.updateNextStepId();
        }
        return spdef;
    }
}

